%{
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

/* Definitions */
#define ID_STRLEN	256				/* ID string length */
#define LINE_LEN	1000			/* line string length */
#define ID_MAX	 	1000			/* id max */
#define VAR_MAX	 	1000			/* var max */
#define LBL_MAX	 	1000			/* label max */
#define LINE_MAX	1000			/* line max */
#define NODE_SIZE	1000			/* node max */
#define IF_MAX		1000			/* if max */
#define FOR_MAX		1000			/* for max */
#define val(x)	    (node[x].left)
#define YYSTYPE int

/* Variables */
typedef struct node { int op; int left,right; } NODE;
NODE node[NODE_SIZE];
int nodeptr , error_flag=0;
int rn = 1;
int cur_ln,prv_ln=0 , rdln=0 , line_acs=0 , line_total=0 , id_total=0;
int var_total=0 , array_total=0 , lbl_acs=0 , lbl_total=0 , if_total=0 , for_total=0;
int printx_total=0 , dummy_nm=0;
int line_num[LINE_MAX], line_flag[LINE_MAX], line_access[LINE_MAX][1];
int lbl_flag[LBL_MAX],lbl_access[LBL_MAX][2];
int if_stackp,if_stackp2,if_stack[IF_MAX],if_stack2[IF_MAX];
int for_stackp,for_stack[FOR_MAX],for_var[FOR_MAX], for_line[FOR_MAX];
char remark[LINE_LEN], inlines[LINE_LEN], prt_str[LINE_LEN];
char identifier[ID_MAX][ID_STRLEN], var_id[VAR_MAX][ID_STRLEN];
char array_id[VAR_MAX][ID_STRLEN], lbl_id[LBL_MAX][ID_STRLEN];
char printx_str[LINE_MAX][LINE_LEN];
int array_size[VAR_MAX];
FILE *infile, *outfile;

/* Function prototypes */
int mknd(int op, int l, int r);
void initnode();
void gencode(int p);
void rem();
void inline_();
void printx();
void mk_end();
void mk_line(int p);
void mk_goto(int p);
void mk_goto_lbl(int p);
void mk_if_then(int p);
void mk_else();
void mk_endif();
void mk_for(int f1,int f2,int f3,int f4);
void mk_next(int p);
int mk_var(int p);
int mk_array(int p,int size);
int mk_lbl(int p);
int ref_line(int line);
int create_line(int line);
int line_exist(int line);
int create_id(char *id_name);
int id_exist(char *id_name);
int create_var(int id_nm);
int create_array(int id_nm,int size);
int var_exist(int id_nm);
int array_exist(int id_nm);
int get_array(int id_nm);
int create_lbl(int id_nm);
int lbl_exist(int id_nm);
int print(char *fmt, ...);
int my_stricmp(char *s1,char *s2);

/*********************************************************
**		compiler main
**********************************************************/
int main(int argc, char *argv[] )
{
	char in_name[64],out_name[64];
	int i;
	char c;
	in_name[0]='\0'; out_name[0]='\0';
	
	printf("Tiny Basic Compiler (LLVM-IR) Ver 0.1  (c)2015 E.Kako\n\n");
	if	(argc!=2) {
		printf("Usage: tinybas source[.bas]\n"); return 0;
	}
	
	if (strchr(argv[1],'.')==0) {
		strcpy(in_name,argv[1]); strcat(in_name,".bas");
		strcpy(out_name,argv[1]); strcat(out_name,".il");
	} else {
		strcpy(in_name,argv[1]);
		i=0; do { c=out_name[i]=in_name[i]; i++; } while (c!='.');
		out_name[i-1]='\0';
		strcat(out_name,".ll");
	}
	if ( (infile=fopen(in_name,"r"))==NULL ) {
		printf("file cannot open.\n"); exit(1);
	}
	if ( (outfile=fopen(out_name,"w"))==NULL ) {
		printf("file cannot create.\n"); exit(1);
	}
	printf("Source File: %s\n",in_name);
	printf("Object File: %s\n",out_name);
	print(";============================================================\n");
	print(";\tCompiler: Tiny Basic Compiler (LLVM-IR) Ver 0.1\n");
	print(";\tSource: %s\n",in_name);
	print(";\tObject: %s\n",out_name);
	print(";============================================================\n");
	print("\n");
	print("@.1 = private unnamed_addr constant [4 x i8] c\"%%d\\0A\\00\", align 1\n");
	print("@.2 = private unnamed_addr constant [3 x i8] c\"?\\0A\\00\", align 1\n");
	print("@buf = common global [1024 x i8] zeroinitializer, align 1\n");
	print("declare i32 @printf(i8*, ...) nounwind\n");
	print("declare i8* @gets(i8*) nounwind\n");
	print("declare i32 @atoi(i8*) nounwind\n");
	print("\n");
	print("define i32 @main() {\n");
	print(";------------------------------------\n");
	print("\t%%acc = alloca i32 , align 4\n");
	for_stackp=0;
	initnode();
	yyparse();
	print("\tbr label %%_END\n\n");
	print("_END:\n");
	print(";------------------------------------\n");
	print("\tret i32 0\n");
	print("}\n");
	for (i=0;i<printx_total;i++) {
		print("@str%d = private unnamed_addr constant [%d x i8]",i+1,strlen(printx_str[i])+2 );
		print(" c\"%s\\0A\\00\", align 1\n",printx_str[i]);
	}
	fclose(infile);
	fclose(outfile);
	return error_flag;
}
int print(char *fmt, ...) /* output */
{
	int r;
	va_list argptr;
	
	va_start(argptr, fmt);
	vfprintf(outfile, fmt, argptr);
	va_end(argptr);
	return 0;
}
%}

/*********************************************************
**		compiler syntax
**********************************************************/
%token		ID
%token		NUMBER
%token		REM LINENUMBER LABEL INLINE
%token		GOTO GOLBL IF THEN ELSE ENDIF FOR TO STEP NEXT END DIM INPUT PRINT PRINTX
%token		'(' ')' '\n'
%left		'=' '<' '>'
%left		'+' '-'
%left		'*' '/' MOD
%left		AND OR XOR
%right		UNARYMINUS NEG
%right		UNARYNEGAT NOT

%%
line	: /* empty */
		| line '\n'			{ initnode(); }
		| line line0 '\n' 	{ gencode($2); initnode(); }
		| line error '\n'	{ yyerrok; initnode(); printf(" in %d\n",cur_ln); }
		;
line0	: linenum line1		{ $$ = mknd(':' , $1 , $2 ); }
		;
line1	: remark			{ $$ = $1; }
		| inline			{ $$ = $1; }
		| printx			{ $$ = $1; }
		| def_lbl			{ $$ = $1; }
		| def_lbl remark	{ $$ = mknd(':' , $1 , $2); }
		| def_lbl ':' stat0 { $$ = mknd(':' , $1 , $3); }
		| stat0 			{ $$ = $1; }
		;
linenum	: NUMBER			{ $$ = mknd(LINENUMBER , 0 , 0); mk_line($1); }
		;
def_lbl	: '*' ID			{ $$ = mknd(LABEL , $2 , 0); mk_lbl($2); }
		;
inline	: INLINE			{ $$ = mknd(INLINE , 0 , 0 ); inline_(); }
		;
printx	: PRINTX			{ $$ = mknd(PRINTX , 0 , 0 ); printx(); }
		;
remark	: REM				{ $$ = mknd(REM , 0 , 0 ); rem(); }
		| ':' REM			{ $$ = mknd(REM , 0 , 0 ); rem(); }
		;
stat0	: states 			{ $$ = $1; }
		| states remark		{ $$ = $1; }
		;
states	: state ':' states	{ $$ = mknd(':' , $1 , $3); }
		| ifbegin ifsts		{ $$ = mknd(':',mknd(':',$1,$2),mknd(ENDIF,0,0)); }
		| state				{ $$ = $1; }
		;
state	: let				{ $$ = $1; }
		| go				{ $$ = $1; }
		| for				{ $$ = $1; }
		| next				{ $$ = $1; }
		| print				{ $$ = $1; }
		| input				{ $$ = $1; }
		| dim				{ $$ = $1; }
		| END				{ $$ = mknd(END , 0 , 0 ); }
		;
let		: var '=' expr		{ $$ = mknd('L', $1, $3); }
		| larray '=' expr	{ $$ = mknd('R', $1, $3); }
		;
larray	: ID '(' expr ')'	{ $$ = mknd('D', $1, $3); }
		;
go		: GOTO const		{ $$ = mknd(GOTO, $2, 0); }
		| GOTO label		{ $$ = mknd(GOLBL, $2, 0); }
		;
ifbegin	: IF expr THEN		 { $$ = mknd(IF,$2,0); }
		;
ifsts	: state ':' ifsts	{ $$ = mknd(':' , $1 , $3); }
		| state				{ $$ = $1; }
		| state else ifsts	{ $$ = mknd(':' , mknd(':' , $1 , $2) , $3); }
		| ifbegin ifsts		{ $$ = mknd(':' , $1 , $2); }
		;
else	: ELSE 				 { $$ = mknd(ELSE,0,0); }
		;
for		: FOR var '=' expr TO expr
							{ $$ = mknd(FOR,$2,mknd(TO,$4,mknd(STEP,$6,-1))); }
		| FOR var '=' expr TO expr STEP expr
							{ $$ = mknd(FOR,$2,mknd(TO,$4,mknd(STEP,$6,$8))); }
		;
next	: NEXT var			{ $$ = mknd(NEXT,$2,0); }
		| NEXT				{ $$ = mknd(NEXT,-1,0); }
		;
print	: PRINT expr		{ $$ = mknd(PRINT,$2,0); }
		;
input	: INPUT var			{ $$ = mknd(INPUT,$2,0); }
		;
label	: '*' ID			{ $$ = mknd('l', $2, 0); }
		;
const	: NUMBER			{ $$ = mknd('C', $1, 0); }
		;
var		: ID				{ $$ = mknd('V', mk_var($1), 0); }
		;
dim		: DIM ID '(' NUMBER ')'
							{ $$ = mknd(DIM , $2 , $4 ); }
		;
array	: ID '(' expr ')'	{ $$ = mknd('A', $1, $3); }
		;
expr	: expr '=' expr		{ $$ = mknd('=', $1, $3); }
		| expr '>' expr		{ $$ = mknd('>', $1, $3); }
		| expr '<' expr		{ $$ = mknd('<', $1, $3); }
		| expr '+' expr		{ $$ = mknd('+', $1, $3); }
		| expr '-' expr		{ $$ = mknd('-', $1, $3); }
		| expr '*' expr		{ $$ = mknd('*', $1, $3); }
		| expr '/' expr		{ $$ = mknd('/', $1, $3); }
		| expr MOD expr		{ $$ = mknd(MOD, $1, $3); }
		| expr AND expr		{ $$ = mknd(AND, $1, $3); }
		| expr OR  expr		{ $$ = mknd(OR , $1, $3); }
		| expr XOR expr		{ $$ = mknd(XOR, $1, $3); }
		| '(' expr ')'		{ $$ = $2; }
		| var				{ $$ = $1; }
		| array				{ $$ = $1; }
		| const				{ $$ = $1; }
		| '-' expr %prec UNARYMINUS   { $$ = mknd(NEG, $2, 0); }
		| NOT expr %prec UNARYNEGAT   { $$ = mknd(NOT, $2, 0); }
		; 
%%

/*********************************************************
**		compiler lexer
**********************************************************/
int yylex()
{
	int c,i;
	char id[100];
	int  v,y;

  while(1) {
	while (((c=yygetc()) == ' ')||(c == '\t'));
	if (isdigit(c)) {
		/* decimal constant */
		yyungetc(c);
		fscanf(infile,"%d", &i);
		yylval = i;
		return  NUMBER;
	} else if (c=='\'') {
		fgets(remark,LINE_LEN-1,infile); yyungetc('\n', infile);
		return REM;
	} else if (c=='&') {
		/* hexadecimal constant */
		c=yygetc();
		if ((c!='h')&&(c!='H')) {
			if (isdigit(c)||((c>='a')&&(c<='f'))||((c>='A')&&(c<='F'))) {
				yyungetc(c);
			} else {
				return '&';
			}
		}
		i=0;
		while(1){
			c=yygetc();
			if (isdigit(c)||((c>='a')&&(c<='f'))||((c>='A')&&(c<='F'))) {
				if (isdigit(c)) {
					i=(i<<4)&0xFFFFFFFF;
					i|=c-'0';
				} else {
					i=(i<<4)&0xFFFFFFFF;
					i|=toupper(c)-'A'+10;
				}
			} else {
				yyungetc(c);
				break;
			}
		}
		yylval = i;
		return  NUMBER;
	} else if (isalpha(c)) {
		v=0;
		while (isalpha(c)||isdigit(c)||(c=='_')) { id[v++]=c; c=yygetc(); }
		yyungetc(c);
		id[v]='\0';
		/* remark */
		if (my_stricmp(id,"REM")==0) {
			fgets(remark,LINE_LEN-1,infile); yyungetc('\n'); return REM;
		}
		if (my_stricmp(id,"INLINE")==0) {
			fgets(inlines,LINE_LEN-1,infile); yyungetc('\n'); return INLINE;
		}
		if (my_stricmp(id,"PRINTX")==0) {
			while (((c=yygetc()) == ' ')||(c == '\t'));
			yyungetc(c);
			fgets(prt_str,LINE_LEN-1,infile); yyungetc('\n'); return PRINTX;
		}
		/* operator , built-in command */
		if (my_stricmp(id,"MOD")==0) { return MOD; }
		if (my_stricmp(id,"AND")==0) { return AND; }
		if (my_stricmp(id,"OR" )==0) { return OR;  }
		if (my_stricmp(id,"XOR")==0) { return XOR; }
		if (my_stricmp(id,"NOT")==0) { return NOT; }
		if (my_stricmp(id,"GOTO")==0)	{ return GOTO; }
		if (my_stricmp(id,"IF")==0)	{ return IF; }
		if (my_stricmp(id,"THEN")==0)	{ return THEN; }
		if (my_stricmp(id,"ELSE")==0)	{ return ELSE; }
		if (my_stricmp(id,"FOR")==0)	{ return FOR; }
		if (my_stricmp(id,"TO")==0)	{ return TO; }
		if (my_stricmp(id,"STEP")==0)	{ return STEP; }
		if (my_stricmp(id,"NEXT")==0)	{ return NEXT; }
		if (my_stricmp(id,"END")==0)	{ return END; }
		if (my_stricmp(id,"DIM")==0)	{ return DIM; }
		if (my_stricmp(id,"INPUT")==0)	{ return INPUT; }
		if (my_stricmp(id,"PRINT")==0)	{ return PRINT; }
		/* other */
		y=id_exist(id);
		if ( y==-1 ) {
			y=create_id(id);
			yylval = y;
		} else {
			yylval = y;
		}
		return ID;
	} else {
		return  c;
	}
  }
}

int yygetc() { return getc(infile); }
int yyungetc(int c) { ungetc(c,infile); return 0; }
int yyerror(char *s) { fputs(s, stdout); error_flag=1; return 0; }
int sv() { print("\t%%%d = load i32* %%acc, align 4\n",rn); rn++; return rn-1; /* save %acc */ }

/*********************************************
**		compiler code generate
**********************************************/
void	gencode(int p)
{
	int l = node[p].left, r = node[p].right;
	int sv_rn;
	int a1,a2,a3,ar;
	int f1,f2,f3,f4,f5,f6,f7;

	switch (node[p].op) {
	case ':': gencode(l); gencode(r); return;							/* multi statement */
	case 'C': print("\tstore i32 %d , i32* %%acc, align 4\n",l); return;/* constant */
	case 'V': print("\t%%%d = load i32* %%_V%d, align 4\n",rn,l);
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* var */
	case 'L': gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\tstore i32 %%%d, i32* %%_V%d ,align 4\n",rn,val(l));
			  rn++; return; 											/* store to var */
	case DIM: mk_array(l,r); return;									/* define array  */
	case 'A': gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  ar=get_array(l);
			  print("\t%%%d = getelementptr inbounds [%d x i32]* %%_A%d,",rn+1,array_size[ar]+1,ar);
			  print(" i32 0, i32 %%%d\n",rn);
			  print("\t%%%d = load i32* %%%d, align 4\n",rn+2,rn+1);
			  print("\tstore i32 %%%d, i32* %%acc\n",rn+2);
			  rn+=3; return;											/* array */
	case 'R': a1=node[l].op; a2=node[l].left; a3=node[l].right;
			  ar=get_array(a2);
			  gencode(a3); sv_rn=sv();
			  gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = getelementptr inbounds [%d x i32]* %%_A%d,",rn+1,array_size[ar]+1,ar);
			  print(" i32 0, i32 %%%d\n",sv_rn);
			  print("\tstore i32 %%%d, i32 * %%%d, align 4\n",rn,rn+1);
			  rn+=2; return;											/* store to array */
	case NEG: gencode(l); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = mul nsw i32 %%%d, -1\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op negate */
	case NOT: gencode(l); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = xor i32 %%%d, -1\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op not */
	case '+': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = add nsw i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op add */
	case '-': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = sub nsw i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op sub */
	case '*': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = mul nsw i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op mul */
	case '/': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = sdiv i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op div */
	case MOD: gencode(l); sv_rn=sv(); gencode(r) ; print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = srem i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op mod */
	case AND: gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = and i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op and */
	case OR:  gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = or i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op or */
	case XOR: gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = xor i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op xor */
	case '=': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = icmp eq i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\t%%%d = sext i1 %%%d to i32\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* compare(=) */
	case '<': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = icmp slt i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\t%%%d = sext i1 %%%d to i32\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* compare(<) */
	case '>': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = icmp sgt i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\t%%%d = sext i1 %%%d to i32\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* compare(>) */
	case LINENUMBER: return;	/* line number (dummy) */
	case LABEL: return;			/* label(dummy) */
	case REM: return;			/* remark(dummy) */
	case INLINE: return;		/* inline(dummy) */
	case PRINTX: return;		/* printx(dummy) */
	case GOTO: mk_goto( val(l) ); return;		/* goto */
	case GOLBL: mk_goto_lbl( val(l) ); return;		/* goto label */
	case IF: mk_if_then(l); return;	/* if then */
	case ELSE: mk_else(); return;	/* else */
	case ENDIF: mk_endif(); return;	/* endif */
	case FOR:	/*  FOR */
		f1=l; f2=node[r].op; f3=node[r].left; f4=node[r].right;
		if (f2==TO) {
			f5=node[f4].op; f6=node[f4].left; f7=node[f4].right;
			if (f5==STEP) { /* for f1=f3 to f6 step f7 */
				mk_for(f1,f3,f6,f7);
			} else {
				printf("Error: 'STEP' Error in %d\n",cur_ln); error_flag=1;
			}
		} else {
				printf("Error: 'TO' Error in %d\n",cur_ln); error_flag=1;
		}
		return;
	case NEXT: mk_next(l); return;	/* next */
	case PRINT:	/* print */
		gencode(l);
		print("\t%%%d = load i32* %%acc, align 4\n",rn);
		print("\t%%%d = call i32(i8*,...)* @printf(i8* getelementptr inbounds([4 x i8]* @.1,",rn+1);
		print(" i32 0, i32 0), i32 %%%d) nounwind\n",rn); rn+=2;
		return;
	case INPUT:	/* input */
		print("\t%%%d = call i32(i8*,...)* @printf(i8* getelementptr inbounds([3 x i8]* @.2,",rn);
		print(" i32 0, i32 0)) nounwind\n"); rn++;
		print("\t%%%d = call i8* @gets(i8* getelementptr inbounds ([1024 x i8]* @buf,",rn);
		print(" i32 0, i32 0)) nounwind\n"); rn++;
		print("\t%%%d = call i32 @atoi(i8* getelementptr inbounds ([1024 x i8]* @buf,",rn);
		print(" i32 0, i32 0)) nounwind\n");
		print("\tstore i32 %%%d, i32* %%_V%d ,align 4\n",rn,val(l)); rn++;
		return;
	case END: mk_end(); return;	/* end */
	}
}

/*********************************************************
**		Subroutines
**********************************************************/
void rem() /* REM */
{
	print(";\tREM %s",remark);
}
void inline_() /* INLINE */
{
	print(";\tINLINE\n\t%s",inlines);
}
void printx() /* PRINTX */
{
	int l;
	l=strlen(prt_str);
	if ((prt_str[l-1]=='\r')||(prt_str[l-1]=='\n')) { prt_str[l-1]='\0'; l--; };
	strcpy(printx_str[printx_total++],prt_str);
	print("\t%%%d = call i32(i8*,...)* @printf(i8* getelementptr inbounds([%d x i8]* @str",rn,l+2);
	print("%d, i32 0, i32 0)) nounwind\n",printx_total); rn++;
}

void mk_end() /* END */
{
	print("\tbr label %%_END\n"); print("GOTO_END:\n");
}

void mk_goto(int p) /* GOTO */
{
	int n;
	n=ref_line(p); print("\tbr label %%_L%d\n",n); print("_DUMMY%d:\n",dummy_nm++); 
}
void mk_goto_lbl(int p) /* GOTO label */
{
	int n;
	n=ref_lbl(p); print("\tbr label %%LBL%d\n",n); print("_DUMMY%d:\n",dummy_nm++); 
}

void mk_if_then(int p) /* IF,THEN */
{
	int ilbl;
	ilbl=if_total;
	if_stack[if_stackp++]=if_total;
	if_stack2[if_stackp2++]=if_total;
	if_total++;
	print("\t;IF\n");
	gencode(p);
	print("\t%%%d = load i32* %%acc, align 4\n",rn);
	print("\t%%%d = trunc i32 %%%d to i1\n",rn+1,rn); rn++;
	print("\tbr i1 %%%d, label %%_IL%d_THEN, ",rn,ilbl); rn++;
	print("label %%_IL%d_ELSE\n",ilbl);
	print("_IL%d_THEN:\n",ilbl);
	return;
}
void mk_else() /* ELSE */
{
	int ilbl;
	if (if_stackp==0) {
		ilbl=0; printf("Error: ELSE without IF.  in %d\n",cur_ln); error_flag=1;
	} else {
		ilbl=if_stack[--if_stackp];
	}
	print("\tbr label %%_IL%d_ENDIF\n",ilbl);
	print("_IL%d_ELSE:\n",ilbl);
	return;
}
void mk_endif() /* ENDIF */
{
	int i,j,ilbl,flag;
	if (if_stackp2==0) {
		printf("Error: ENDIF without IF.  in %d\n",cur_ln); error_flag=1;
	}
	for (i=0;i<if_stackp2;i++) {
		ilbl=if_stack2[i];
		if (if_stackp==0) {
			print("\tbr label %%_IL%d_ENDIF\n",ilbl);
			print("_IL%d_ENDIF:\n",ilbl);
		} else {
			flag=0;
			for (j=0;j<if_stackp;j++) {
				if (if_stack[j]==ilbl) flag=1;
			}
			if (flag==0) {
				print("\tbr label %%_IL%d_ENDIF\n",ilbl);
				print("_IL%d_ENDIF:\n",ilbl);
			} else {
				print("\tbr label %%_IL%d_ELSE\n",ilbl);
				print("_IL%d_ELSE:\n",ilbl);
				print("\tbr label %%_IL%d_ENDIF\n",ilbl);
				print("_IL%d_ENDIF:\n",ilbl);
			}
		}
	}
	return;
}

void mk_for(int f1,int f2,int f3,int f4) /* FOR */
{
	int step,flbl,sv_r_nm;
	if (f4==-1) {
		step=1; /* no STEP */
	} else {
		if (node[f4].op=='C') {
			step=node[f4].left;
		} else {
			step=1; printf("FOR's STEP must be constant. in %d\n",cur_ln);
		}
	}
	if (step==0) {
		step=1; printf("STEP should not be zero.\n");
	}
	/*   var = f1     */
	print("\t;FOR\n");
	if (node[f1].op == 'V') {
		gencode(f2);
	}
	print("\t%%%d = load i32* %%acc, align 4\n",rn);
	print("\t%%%d = sub nsw i32 %%%d, %d\n",rn+1,rn,step);
	print("\tstore i32 %%%d, i32* %%_V%d\n",rn+1,val(f1));  rn+=2;
	flbl=for_total;
	for_stack[for_stackp++]=for_total;
	for_var[for_total]=val(f1);
	for_line[for_total]=cur_ln;
	for_total++;
	print("\tbr label %%_FL%d\n",flbl);
	print("_FL%d:\n",flbl);
	print("\t%%%d = load i32* %%_V%d, align 4\n",rn,val(f1));
	print("\t%%%d = add nsw i32 %%%d, %d\n",rn+1,rn,step);
	print("\tstore i32 %%%d, i32* %%_V%d\n",rn+1,val(f1)); sv_r_nm=rn+1; rn+=2;
	gencode(f3);
	print("\t%%%d = load i32* %%acc, align 4\n",rn);
	if (step>0) {
		print("\t%%%d = icmp sgt i32 %%%d, %%%d\n",rn+1,sv_r_nm,rn); rn++;
		print("\tbr i1 %%%d, label %%_FL%d_END, ",rn,flbl); rn++;
		print("label %%_FL%d_F\n",flbl);
	} else if (step<0) {
		print("\t%%%d = icmp slt i32 %%%d, %%%d\n",rn+1,sv_r_nm,rn); rn++;
		print("\tbr i1 %%%d, label %%_FL%d_END, ",rn,flbl); rn++;
		print("label %%_FL%d_F\n",flbl);
	}
	print("_FL%d_F:\n",flbl);
	return;
}
void mk_next(int p) /* NEXT */
{
	int flbl,fvar,fl;
	if (for_stackp==0) {
		flbl=99999; printf("Error: NEXT without FOR.  in %d\n",cur_ln); error_flag=1;
	} else {
		flbl=for_stack[--for_stackp];
	}
	fvar=for_var[flbl]; fl=for_line[flbl];
	if (p==-1) { /* NEXT without var */
		print("\tbr label %%_FL%d\n",flbl);
		print("\t;NEXT\n");
		print("_FL%d_END:\n",flbl);
	} else { /* NEXT with var */
		if (val(p)!=fvar) {
			printf("Error: FOR and NEXT variable doesn't match in %d,%d\n",fl,cur_ln); error_flag=1;
		}
		print("\tbr label %%_FL%d\n",flbl);
		print("\t;NEXT\n");
		print("_FL%d_END:\n",flbl);
	}
	return;
}

void initnode() /* init tree */
{
	nodeptr = 0; if_stackp = 0; if_stackp2 = 0;
}

int mknd(int op, int l, int r) /* make node of tree */
{
	if ((op==NEG)&&(node[l].op=='C')) {	  /* negate op + const */
		node[l].left = -val(l); return l;
	}
	node[nodeptr].op = op; node[nodeptr].left = l; node[nodeptr].right = r;
	return  nodeptr++;
}

int create_id(char *id_name) /* identifier */
{
	strcpy( identifier[id_total], id_name ); id_total++;
	return id_total-1;
}
int id_exist(char *id_name)
{
	int	i;
	if (id_total==0) return -1;
	for (i=0;i<id_total;i++) {
		if ( my_stricmp(identifier[i],id_name )==0 ) { return i; }
	}
	return -1;
}

int mk_var(int p) /* integer variable */
{
	int i,id_nm=p;
	if ((i=var_exist(id_nm))==-1) {
		i=create_var(id_nm); print("\t%%_V%d = alloca i32 , align 4\n",i);
	}
	return i;
}
int create_var(int id_nm)
{
	strcpy( var_id[var_total], identifier[id_nm] ); var_total++;
	return var_total-1;
}
int var_exist(int id_nm)
{
	int	i;
	if (var_total==0) { return -1; }
	for (i=0;i<var_total;i++) {
		if ( my_stricmp(var_id[i], identifier[id_nm] )==0 ) { return i; }
	}
	return -1;
}

int mk_array(int p , int size) /* integer array */
{
	int i,id_nm=(int)p;
	if ((i=array_exist(id_nm))==-1) {
		i=create_array(id_nm,size);
		print("\t%%_A%d = alloca [%d x i32], align 4\n",i,size+1);
	}
	return i;
}
int create_array(int id_nm,int size)
{
	strcpy( array_id[array_total], identifier[id_nm] ); array_size[array_total]=size; array_total++;
	return array_total-1;
}
int array_exist(int id_nm)
{
	int	i;
	if (array_total==0) { return -1; }
	for (i=0;i<array_total;i++) {
		if ( my_stricmp(array_id[i], identifier[id_nm] )==0 ) { return i; }
	}
	return -1;
}
int get_array(int id_nm)
{
	int i;
	i= array_exist(id_nm);
	if (i == -1) { printf("Error: illegal array id=%d %s\n",id_nm,identifier[id_nm]); i=0; }
	return i;
}

int mk_lbl(int p) /* label */
{
	int	i,id_nm=p;
	if ((i=lbl_exist(id_nm))==-1) {
		i=create_lbl(id_nm); lbl_flag[i]=0x01; print("\tbr label %%LBL%d\n",i); print("LBL%d:\n",i);
		return i;
	} else {
		if ( (lbl_flag[i] == 0x01) || (lbl_flag[i] == 0x03) ) {
			print("LBL%d:\n",i);
			printf("error: Duplicate Label %s\n",lbl_id[i]);
		} else {
			lbl_flag[i]+=0x01;  print("\tbr label %%LBL%d\n",i); print("LBL%d:\n",i);
		}
		return i;
	}
}
int ref_lbl(int p)
{
	int	i,id_nm=p;
	if ((i=lbl_exist(id_nm))==-1) {
		i=create_lbl(id_nm);
		lbl_flag[i]=0x02;	/*   referenced flag   */
	} else {
		lbl_flag[i]|=0x02;	/*   referenced flag   */
	}
	lbl_access[lbl_acs][0]=i; lbl_access[lbl_acs][1]=cur_ln; lbl_acs++;
	return i;
}
int create_lbl(int id_nm)
{
	strcpy( lbl_id[lbl_total], identifier[id_nm] ); lbl_total++;
	return lbl_total-1;
}
int lbl_exist(int id_nm)
{
	int	i;
	if (lbl_total==0) { return -1; }
	for (i=0;i<lbl_total;i++) {
		if ( my_stricmp(lbl_id[i], identifier[id_nm] )==0 ) { return i; }
	}
	return -1;
}

void mk_line(int p) /* line number */
{
	int ll;
	int line=p;
	if ( cur_ln < prv_ln ) {
		printf("warning: Line %d < %d \n",cur_ln,prv_ln);
	} else {
		prv_ln=cur_ln;
	}
	cur_ln=line; rdln++;
	if ( (ll=line_exist(line))<0 ) {
		ll=create_line(line);line_flag[ll]=0x01; print("\tbr label %%_L%d\n\n_L%d:\n",cur_ln,cur_ln);
	} else {
		if ( (line_flag[ll] == 0x01) || (line_flag[ll] == 0x03) ) {
			print("\n_L%d:\n",cur_ln);
			printf("error: Dupulicate Line %d\n",line);
		} else {
			line_flag[ll]+=0x01; print("\tbr label %%_L%d\n\n_L%d:\n",cur_ln,cur_ln);
		}
	}
}
int ref_line(int line)
{
	int l;
	if ( (l=line_exist(line))<0 ) {
		l=create_line(line); line_flag[l]=0x02;
	} else {
		line_flag[l]|=0x02;
	}
	line_access[line_acs][0]=l; line_access[line_acs][1]=cur_ln; line_acs++;
	return line;
}
int create_line(int line)
{
	line_num[line_total]=line; line_total++;
	return line_total-1;
}
int line_exist(int line)
{
	int i;
	if (line_total==0) { return -1; }
	for (i=0;i<line_total;i++) {
		if ( line_num[i]==line ) { return i; }
	}
	return -1;
}

int my_stricmp(char *s1,char *s2)
{
	char c1,c2;
	while (1) {
		c1=*s1++; c2=*s2++; c1=tolower(c1); c2=tolower(c2);
		if ((c1=='\0')||(c2=='\0')||(c1!=c2)) { break; }
	}
	return (int) c1-c2;
}
