/* A Bison parser, made by GNU Bison 3.0.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "tinybas.y" /* yacc.c:339  */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

/* Definitions */
#define ID_STRLEN	256				/* ID string length */
#define LINE_LEN	1000			/* line string length */
#define ID_MAX	 	1000			/* id max */
#define VAR_MAX	 	1000			/* var max */
#define LBL_MAX	 	1000			/* label max */
#define LINE_MAX	1000			/* line max */
#define NODE_SIZE	1000			/* node max */
#define IF_MAX		1000			/* if max */
#define FOR_MAX		1000			/* for max */
#define val(x)	    (node[x].left)
#define YYSTYPE int

/* Variables */
typedef struct node { int op; int left,right; } NODE;
NODE node[NODE_SIZE];
int nodeptr , error_flag=0;
int rn = 1;
int cur_ln,prv_ln=0 , rdln=0 , line_acs=0 , line_total=0 , id_total=0;
int var_total=0 , array_total=0 , lbl_acs=0 , lbl_total=0 , if_total=0 , for_total=0;
int printx_total=0 , dummy_nm=0;
int line_num[LINE_MAX], line_flag[LINE_MAX], line_access[LINE_MAX][1];
int lbl_flag[LBL_MAX],lbl_access[LBL_MAX][2];
int if_stackp,if_stackp2,if_stack[IF_MAX],if_stack2[IF_MAX];
int for_stackp,for_stack[FOR_MAX],for_var[FOR_MAX], for_line[FOR_MAX];
char remark[LINE_LEN], inlines[LINE_LEN], prt_str[LINE_LEN];
char identifier[ID_MAX][ID_STRLEN], var_id[VAR_MAX][ID_STRLEN];
char array_id[VAR_MAX][ID_STRLEN], lbl_id[LBL_MAX][ID_STRLEN];
char printx_str[LINE_MAX][LINE_LEN];
int array_size[VAR_MAX];
FILE *infile, *outfile;

/* Function prototypes */
int mknd(int op, int l, int r);
void initnode();
void gencode(int p);
void rem();
void inline_();
void printx();
void mk_end();
void mk_line(int p);
void mk_goto(int p);
void mk_goto_lbl(int p);
void mk_if_then(int p);
void mk_else();
void mk_endif();
void mk_for(int f1,int f2,int f3,int f4);
void mk_next(int p);
int mk_var(int p);
int mk_array(int p,int size);
int mk_lbl(int p);
int ref_line(int line);
int create_line(int line);
int line_exist(int line);
int create_id(char *id_name);
int id_exist(char *id_name);
int create_var(int id_nm);
int create_array(int id_nm,int size);
int var_exist(int id_nm);
int array_exist(int id_nm);
int get_array(int id_nm);
int create_lbl(int id_nm);
int lbl_exist(int id_nm);
int print(char *fmt, ...);
int my_stricmp(char *s1,char *s2);

/*********************************************************
**		compiler main
**********************************************************/
int main(int argc, char *argv[] )
{
	char in_name[64],out_name[64];
	int i;
	char c;
	in_name[0]='\0'; out_name[0]='\0';
	
	printf("Tiny Basic Compiler (LLVM-IR) Ver 0.1  (c)2015 E.Kako\n\n");
	if	(argc!=2) {
		printf("Usage: tinybas source[.bas]\n"); return 0;
	}
	
	if (strchr(argv[1],'.')==0) {
		strcpy(in_name,argv[1]); strcat(in_name,".bas");
		strcpy(out_name,argv[1]); strcat(out_name,".il");
	} else {
		strcpy(in_name,argv[1]);
		i=0; do { c=out_name[i]=in_name[i]; i++; } while (c!='.');
		out_name[i-1]='\0';
		strcat(out_name,".ll");
	}
	if ( (infile=fopen(in_name,"r"))==NULL ) {
		printf("file cannot open.\n"); exit(1);
	}
	if ( (outfile=fopen(out_name,"w"))==NULL ) {
		printf("file cannot create.\n"); exit(1);
	}
	printf("Source File: %s\n",in_name);
	printf("Object File: %s\n",out_name);
	print(";============================================================\n");
	print(";\tCompiler: Tiny Basic Compiler (LLVM-IR) Ver 0.1\n");
	print(";\tSource: %s\n",in_name);
	print(";\tObject: %s\n",out_name);
	print(";============================================================\n");
	print("\n");
	print("@.1 = private unnamed_addr constant [4 x i8] c\"%%d\\0A\\00\", align 1\n");
	print("@.2 = private unnamed_addr constant [3 x i8] c\"?\\0A\\00\", align 1\n");
	print("@buf = common global [1024 x i8] zeroinitializer, align 1\n");
	print("declare i32 @printf(i8*, ...) nounwind\n");
	print("declare i8* @gets(i8*) nounwind\n");
	print("declare i32 @atoi(i8*) nounwind\n");
	print("\n");
	print("define i32 @main() {\n");
	print(";------------------------------------\n");
	print("\t%%acc = alloca i32 , align 4\n");
	for_stackp=0;
	initnode();
	yyparse();
	print("\tbr label %%_END\n\n");
	print("_END:\n");
	print(";------------------------------------\n");
	print("\tret i32 0\n");
	print("}\n");
	for (i=0;i<printx_total;i++) {
		print("@str%d = private unnamed_addr constant [%d x i8]",i+1,strlen(printx_str[i])+2 );
		print(" c\"%s\\0A\\00\", align 1\n",printx_str[i]);
	}
	fclose(infile);
	fclose(outfile);
	return error_flag;
}
int print(char *fmt, ...) /* output */
{
	int r;
	va_list argptr;
	
	va_start(argptr, fmt);
	vfprintf(outfile, fmt, argptr);
	va_end(argptr);
	return 0;
}

#line 215 "tinybas.tab.c" /* yacc.c:339  */

# ifndef YY_NULL
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULL nullptr
#  else
#   define YY_NULL 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    ID = 258,
    NUMBER = 259,
    REM = 260,
    LINENUMBER = 261,
    LABEL = 262,
    INLINE = 263,
    GOTO = 264,
    GOLBL = 265,
    IF = 266,
    THEN = 267,
    ELSE = 268,
    ENDIF = 269,
    FOR = 270,
    TO = 271,
    STEP = 272,
    NEXT = 273,
    END = 274,
    DIM = 275,
    INPUT = 276,
    PRINT = 277,
    PRINTX = 278,
    MOD = 279,
    AND = 280,
    OR = 281,
    XOR = 282,
    UNARYMINUS = 283,
    NEG = 284,
    UNARYNEGAT = 285,
    NOT = 286
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);



/* Copy the second part of user declarations.  */

#line 295 "tinybas.tab.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef __attribute__
/* This feature is available in gcc versions 2.5 and later.  */
# if (! defined __GNUC__ || __GNUC__ < 2 \
      || (__GNUC__ == 2 && __GNUC_MINOR__ < 5))
#  define __attribute__(Spec) /* empty */
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   255

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  43
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  28
/* YYNRULES -- Number of rules.  */
#define YYNRULES  71
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  124

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   286

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      26,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      24,    25,    32,    30,     2,    31,     2,    33,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    42,     2,
      28,    27,    29,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    34,
      35,    36,    37,    38,    39,    40,    41
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   166,   166,   167,   168,   169,   171,   173,   174,   175,
     176,   177,   178,   179,   181,   183,   185,   187,   189,   190,
     192,   193,   195,   196,   197,   199,   200,   201,   202,   203,
     204,   205,   206,   208,   209,   211,   213,   214,   216,   218,
     219,   220,   221,   223,   225,   227,   230,   231,   233,   235,
     237,   239,   241,   243,   246,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "NUMBER", "REM", "LINENUMBER",
  "LABEL", "INLINE", "GOTO", "GOLBL", "IF", "THEN", "ELSE", "ENDIF", "FOR",
  "TO", "STEP", "NEXT", "END", "DIM", "INPUT", "PRINT", "PRINTX", "'('",
  "')'", "'\\n'", "'='", "'<'", "'>'", "'+'", "'-'", "'*'", "'/'", "MOD",
  "AND", "OR", "XOR", "UNARYMINUS", "NEG", "UNARYNEGAT", "NOT", "':'",
  "$accept", "line", "line0", "line1", "linenum", "def_lbl", "inline",
  "printx", "remark", "stat0", "states", "state", "let", "larray", "go",
  "ifbegin", "ifsts", "else", "for", "next", "print", "input", "label",
  "const", "var", "dim", "array", "expr", YY_NULL
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    40,    41,    10,    61,    60,    62,
      43,    45,    42,    47,   279,   280,   281,   282,   283,   284,
     285,   286,    58
};
# endif

#define YYPACT_NINF -61

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-61)))

#define YYTABLE_NINF -1

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -61,     7,   -61,   -14,   -61,   -61,     0,    75,   -61,   -61,
     -10,   -61,   -61,    -1,     1,    31,    31,   -61,    37,    31,
       1,   -61,    38,     5,   -61,    -4,   -61,   -61,   -61,   -61,
      -3,     2,   -61,    18,   -61,   183,   -61,   -61,   -61,   -61,
      19,   -61,     1,   -61,    45,   -61,   -61,    25,     1,     1,
       1,   -61,   -61,   -61,    91,   -61,    23,   -61,    28,   -61,
     218,   -61,   -61,   169,   -61,   -61,   183,     1,    -7,   183,
     -61,     1,   181,   -61,     1,   194,   -61,   -61,   -61,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,    49,   -61,   -61,   218,   -61,   183,   183,   -61,   218,
     -61,   207,   -61,    78,    78,    78,    98,    98,   -16,   -16,
     -16,   -61,   -61,   -61,   113,    30,   -61,   -61,   -61,     1,
     -61,   134,     1,   218
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       2,     0,     1,     0,    14,     3,     0,     0,     5,     4,
      52,    18,    16,     0,     0,     0,    47,    32,     0,     0,
       0,    17,     0,     0,     6,    10,     8,     9,     7,    13,
      20,    24,    25,     0,    26,     0,    27,    28,    29,    30,
       0,    31,     0,    51,     0,    37,    36,    52,     0,     0,
       0,    69,    67,    68,     0,    52,     0,    46,     0,    49,
      48,    15,    19,     0,    11,    21,     0,     0,    40,     0,
      23,     0,     0,    50,     0,     0,    70,    71,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    12,    22,    34,    43,     0,     0,    42,    33,
      35,     0,    66,    55,    57,    56,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,    39,    41,    54,     0,
      53,    44,     0,    45
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -61,   -61,   -61,   -61,   -61,   -61,   -61,   -61,   -12,    -6,
      -8,     9,   -61,   -61,   -61,    10,   -60,   -61,   -61,   -61,
     -61,   -61,   -61,    43,     8,   -61,   -61,   -20
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     1,     6,    24,     7,    25,    26,    27,    28,    29,
      30,    68,    32,    33,    34,    69,    70,    97,    36,    37,
      38,    39,    45,    51,    52,    41,    53,    54
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      60,    11,    11,    43,    47,    43,    95,     2,     3,    98,
      62,     4,     8,    64,    42,    40,    31,    35,    65,    87,
      88,    89,    72,    56,    57,    48,     9,    59,    75,    76,
      77,    44,    49,     5,    55,    96,   116,   117,    63,    23,
      58,    61,    50,    40,    66,    67,    71,    94,    73,    74,
      90,    99,    91,   115,   101,   120,    46,    92,    93,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,    40,    31,    35,    40,    31,    35,    40,    10,     0,
      11,     0,     0,    12,    13,     0,    14,     0,     0,     0,
      15,     0,     0,    16,    17,    18,    19,    20,    21,   121,
       0,     0,   123,    78,    40,    40,     0,    22,    82,    83,
      84,    85,    86,    87,    88,    89,     0,    23,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,   119,
      84,    85,    86,    87,    88,    89,     0,     0,     0,     0,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,   122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    10,     0,    62,     0,     0,     0,    13,     0,
      14,     0,     0,     0,    15,     0,    10,    16,    17,    18,
      19,    20,    13,     0,    14,     0,     0,     0,    15,     0,
       0,    16,    17,    18,    19,    20,   100,     0,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,   102,
       0,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,   118,     0,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89
};

static const yytype_int8 yycheck[] =
{
      20,     5,     5,     4,     3,     4,    13,     0,     1,    69,
       5,     4,    26,    25,    24,     7,     7,     7,    30,    35,
      36,    37,    42,    15,    16,    24,    26,    19,    48,    49,
      50,    32,    31,    26,     3,    42,    96,    97,    42,    42,
       3,     3,    41,    35,    42,    27,    27,    67,     3,    24,
      27,    71,    24,     4,    74,    25,    13,    63,    66,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    63,    63,    63,    66,    66,    66,    69,     3,    -1,
       5,    -1,    -1,     8,     9,    -1,    11,    -1,    -1,    -1,
      15,    -1,    -1,    18,    19,    20,    21,    22,    23,   119,
      -1,    -1,   122,    12,    96,    97,    -1,    32,    30,    31,
      32,    33,    34,    35,    36,    37,    -1,    42,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    16,
      32,    33,    34,    35,    36,    37,    -1,    -1,    -1,    -1,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,     3,    -1,     5,    -1,    -1,    -1,     9,    -1,
      11,    -1,    -1,    -1,    15,    -1,     3,    18,    19,    20,
      21,    22,     9,    -1,    11,    -1,    -1,    -1,    15,    -1,
      -1,    18,    19,    20,    21,    22,    25,    -1,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    25,
      -1,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    25,    -1,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    44,     0,     1,     4,    26,    45,    47,    26,    26,
       3,     5,     8,     9,    11,    15,    18,    19,    20,    21,
      22,    23,    32,    42,    46,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    61,    62,    63,    64,
      67,    68,    24,     4,    32,    65,    66,     3,    24,    31,
      41,    66,    67,    69,    70,     3,    67,    67,     3,    67,
      70,     3,     5,    42,    51,    51,    42,    27,    54,    58,
      59,    27,    70,     3,    24,    70,    70,    70,    12,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      27,    24,    52,    53,    70,    13,    42,    60,    59,    70,
      25,    70,    25,    70,    70,    70,    70,    70,    70,    70,
      70,    70,    70,    70,    70,     4,    59,    59,    25,    16,
      25,    70,    17,    70
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    43,    44,    44,    44,    44,    45,    46,    46,    46,
      46,    46,    46,    46,    47,    48,    49,    50,    51,    51,
      52,    52,    53,    53,    53,    54,    54,    54,    54,    54,
      54,    54,    54,    55,    55,    56,    57,    57,    58,    59,
      59,    59,    59,    60,    61,    61,    62,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    70,    70,    70,    70,
      70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
      70,    70
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     2,     3,     3,     2,     1,     1,     1,
       1,     2,     3,     1,     1,     2,     1,     1,     1,     2,
       1,     2,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     4,     2,     2,     3,     3,
       1,     3,     2,     1,     6,     8,     2,     1,     2,     2,
       2,     1,     1,     5,     4,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     1,     1,     1,
       2,     2
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULL, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULL;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULL, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 167 "tinybas.y" /* yacc.c:1646  */
    { initnode(); }
#line 1466 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 4:
#line 168 "tinybas.y" /* yacc.c:1646  */
    { gencode((yyvsp[-1])); initnode(); }
#line 1472 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 5:
#line 169 "tinybas.y" /* yacc.c:1646  */
    { yyerrok; initnode(); printf(" in %d\n",cur_ln); }
#line 1478 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 6:
#line 171 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':' , (yyvsp[-1]) , (yyvsp[0]) ); }
#line 1484 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 7:
#line 173 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1490 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 8:
#line 174 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1496 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 9:
#line 175 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1502 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 10:
#line 176 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1508 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 11:
#line 177 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':' , (yyvsp[-1]) , (yyvsp[0])); }
#line 1514 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 12:
#line 178 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':' , (yyvsp[-2]) , (yyvsp[0])); }
#line 1520 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 13:
#line 179 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1526 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 14:
#line 181 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(LINENUMBER , 0 , 0); mk_line((yyvsp[0])); }
#line 1532 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 15:
#line 183 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(LABEL , (yyvsp[0]) , 0); mk_lbl((yyvsp[0])); }
#line 1538 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 16:
#line 185 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(INLINE , 0 , 0 ); inline_(); }
#line 1544 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 17:
#line 187 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(PRINTX , 0 , 0 ); printx(); }
#line 1550 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 18:
#line 189 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(REM , 0 , 0 ); rem(); }
#line 1556 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 19:
#line 190 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(REM , 0 , 0 ); rem(); }
#line 1562 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 20:
#line 192 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1568 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 21:
#line 193 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 1574 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 22:
#line 195 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':' , (yyvsp[-2]) , (yyvsp[0])); }
#line 1580 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 23:
#line 196 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':',mknd(':',(yyvsp[-1]),(yyvsp[0])),mknd(ENDIF,0,0)); }
#line 1586 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 24:
#line 197 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1592 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 25:
#line 199 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1598 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 26:
#line 200 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1604 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 27:
#line 201 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1610 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 28:
#line 202 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1616 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 29:
#line 203 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1622 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 30:
#line 204 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1628 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 31:
#line 205 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1634 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 32:
#line 206 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(END , 0 , 0 ); }
#line 1640 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 33:
#line 208 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('L', (yyvsp[-2]), (yyvsp[0])); }
#line 1646 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 34:
#line 209 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('R', (yyvsp[-2]), (yyvsp[0])); }
#line 1652 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 35:
#line 211 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('D', (yyvsp[-3]), (yyvsp[-1])); }
#line 1658 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 36:
#line 213 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(GOTO, (yyvsp[0]), 0); }
#line 1664 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 37:
#line 214 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(GOLBL, (yyvsp[0]), 0); }
#line 1670 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 38:
#line 216 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(IF,(yyvsp[-1]),0); }
#line 1676 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 39:
#line 218 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':' , (yyvsp[-2]) , (yyvsp[0])); }
#line 1682 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 40:
#line 219 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1688 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 41:
#line 220 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':' , mknd(':' , (yyvsp[-2]) , (yyvsp[-1])) , (yyvsp[0])); }
#line 1694 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 42:
#line 221 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(':' , (yyvsp[-1]) , (yyvsp[0])); }
#line 1700 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 43:
#line 223 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(ELSE,0,0); }
#line 1706 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 44:
#line 226 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(FOR,(yyvsp[-4]),mknd(TO,(yyvsp[-2]),mknd(STEP,(yyvsp[0]),-1))); }
#line 1712 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 45:
#line 228 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(FOR,(yyvsp[-6]),mknd(TO,(yyvsp[-4]),mknd(STEP,(yyvsp[-2]),(yyvsp[0])))); }
#line 1718 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 46:
#line 230 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(NEXT,(yyvsp[0]),0); }
#line 1724 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 47:
#line 231 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(NEXT,-1,0); }
#line 1730 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 48:
#line 233 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(PRINT,(yyvsp[0]),0); }
#line 1736 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 49:
#line 235 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(INPUT,(yyvsp[0]),0); }
#line 1742 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 50:
#line 237 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('l', (yyvsp[0]), 0); }
#line 1748 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 51:
#line 239 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('C', (yyvsp[0]), 0); }
#line 1754 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 52:
#line 241 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('V', mk_var((yyvsp[0])), 0); }
#line 1760 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 53:
#line 244 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(DIM , (yyvsp[-3]) , (yyvsp[-1]) ); }
#line 1766 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 54:
#line 246 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('A', (yyvsp[-3]), (yyvsp[-1])); }
#line 1772 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 55:
#line 248 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('=', (yyvsp[-2]), (yyvsp[0])); }
#line 1778 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 56:
#line 249 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('>', (yyvsp[-2]), (yyvsp[0])); }
#line 1784 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 57:
#line 250 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('<', (yyvsp[-2]), (yyvsp[0])); }
#line 1790 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 58:
#line 251 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('+', (yyvsp[-2]), (yyvsp[0])); }
#line 1796 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 59:
#line 252 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('-', (yyvsp[-2]), (yyvsp[0])); }
#line 1802 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 60:
#line 253 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('*', (yyvsp[-2]), (yyvsp[0])); }
#line 1808 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 61:
#line 254 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd('/', (yyvsp[-2]), (yyvsp[0])); }
#line 1814 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 62:
#line 255 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(MOD, (yyvsp[-2]), (yyvsp[0])); }
#line 1820 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 63:
#line 256 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(AND, (yyvsp[-2]), (yyvsp[0])); }
#line 1826 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 64:
#line 257 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(OR , (yyvsp[-2]), (yyvsp[0])); }
#line 1832 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 65:
#line 258 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(XOR, (yyvsp[-2]), (yyvsp[0])); }
#line 1838 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 66:
#line 259 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 1844 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 67:
#line 260 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1850 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 68:
#line 261 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1856 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 69:
#line 262 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 1862 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 70:
#line 263 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(NEG, (yyvsp[0]), 0); }
#line 1868 "tinybas.tab.c" /* yacc.c:1646  */
    break;

  case 71:
#line 264 "tinybas.y" /* yacc.c:1646  */
    { (yyval) = mknd(NOT, (yyvsp[0]), 0); }
#line 1874 "tinybas.tab.c" /* yacc.c:1646  */
    break;


#line 1878 "tinybas.tab.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 266 "tinybas.y" /* yacc.c:1906  */


/*********************************************************
**		compiler lexer
**********************************************************/
int yylex()
{
	int c,i;
	char id[100];
	int  v,y;

  while(1) {
	while (((c=yygetc()) == ' ')||(c == '\t'));
	if (isdigit(c)) {
		/* decimal constant */
		yyungetc(c);
		fscanf(infile,"%d", &i);
		yylval = i;
		return  NUMBER;
	} else if (c=='\'') {
		fgets(remark,LINE_LEN-1,infile); yyungetc('\n', infile);
		return REM;
	} else if (c=='&') {
		/* hexadecimal constant */
		c=yygetc();
		if ((c!='h')&&(c!='H')) {
			if (isdigit(c)||((c>='a')&&(c<='f'))||((c>='A')&&(c<='F'))) {
				yyungetc(c);
			} else {
				return '&';
			}
		}
		i=0;
		while(1){
			c=yygetc();
			if (isdigit(c)||((c>='a')&&(c<='f'))||((c>='A')&&(c<='F'))) {
				if (isdigit(c)) {
					i=(i<<4)&0xFFFFFFFF;
					i|=c-'0';
				} else {
					i=(i<<4)&0xFFFFFFFF;
					i|=toupper(c)-'A'+10;
				}
			} else {
				yyungetc(c);
				break;
			}
		}
		yylval = i;
		return  NUMBER;
	} else if (isalpha(c)) {
		v=0;
		while (isalpha(c)||isdigit(c)||(c=='_')) { id[v++]=c; c=yygetc(); }
		yyungetc(c);
		id[v]='\0';
		/* remark */
		if (my_stricmp(id,"REM")==0) {
			fgets(remark,LINE_LEN-1,infile); yyungetc('\n'); return REM;
		}
		if (my_stricmp(id,"INLINE")==0) {
			fgets(inlines,LINE_LEN-1,infile); yyungetc('\n'); return INLINE;
		}
		if (my_stricmp(id,"PRINTX")==0) {
			while (((c=yygetc()) == ' ')||(c == '\t'));
			yyungetc(c);
			fgets(prt_str,LINE_LEN-1,infile); yyungetc('\n'); return PRINTX;
		}
		/* operator , built-in command */
		if (my_stricmp(id,"MOD")==0) { return MOD; }
		if (my_stricmp(id,"AND")==0) { return AND; }
		if (my_stricmp(id,"OR" )==0) { return OR;  }
		if (my_stricmp(id,"XOR")==0) { return XOR; }
		if (my_stricmp(id,"NOT")==0) { return NOT; }
		if (my_stricmp(id,"GOTO")==0)	{ return GOTO; }
		if (my_stricmp(id,"IF")==0)	{ return IF; }
		if (my_stricmp(id,"THEN")==0)	{ return THEN; }
		if (my_stricmp(id,"ELSE")==0)	{ return ELSE; }
		if (my_stricmp(id,"FOR")==0)	{ return FOR; }
		if (my_stricmp(id,"TO")==0)	{ return TO; }
		if (my_stricmp(id,"STEP")==0)	{ return STEP; }
		if (my_stricmp(id,"NEXT")==0)	{ return NEXT; }
		if (my_stricmp(id,"END")==0)	{ return END; }
		if (my_stricmp(id,"DIM")==0)	{ return DIM; }
		if (my_stricmp(id,"INPUT")==0)	{ return INPUT; }
		if (my_stricmp(id,"PRINT")==0)	{ return PRINT; }
		/* other */
		y=id_exist(id);
		if ( y==-1 ) {
			y=create_id(id);
			yylval = y;
		} else {
			yylval = y;
		}
		return ID;
	} else {
		return  c;
	}
  }
}

int yygetc() { return getc(infile); }
int yyungetc(int c) { ungetc(c,infile); return 0; }
int yyerror(char *s) { fputs(s, stdout); error_flag=1; return 0; }
int sv() { print("\t%%%d = load i32* %%acc, align 4\n",rn); rn++; return rn-1; /* save %acc */ }

/*********************************************
**		compiler code generate
**********************************************/
void	gencode(int p)
{
	int l = node[p].left, r = node[p].right;
	int sv_rn;
	int a1,a2,a3,ar;
	int f1,f2,f3,f4,f5,f6,f7;

	switch (node[p].op) {
	case ':': gencode(l); gencode(r); return;							/* multi statement */
	case 'C': print("\tstore i32 %d , i32* %%acc, align 4\n",l); return;/* constant */
	case 'V': print("\t%%%d = load i32* %%_V%d, align 4\n",rn,l);
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* var */
	case 'L': gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\tstore i32 %%%d, i32* %%_V%d ,align 4\n",rn,val(l));
			  rn++; return; 											/* store to var */
	case DIM: mk_array(l,r); return;									/* define array  */
	case 'A': gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  ar=get_array(l);
			  print("\t%%%d = getelementptr inbounds [%d x i32]* %%_A%d,",rn+1,array_size[ar]+1,ar);
			  print(" i32 0, i32 %%%d\n",rn);
			  print("\t%%%d = load i32* %%%d, align 4\n",rn+2,rn+1);
			  print("\tstore i32 %%%d, i32* %%acc\n",rn+2);
			  rn+=3; return;											/* array */
	case 'R': a1=node[l].op; a2=node[l].left; a3=node[l].right;
			  ar=get_array(a2);
			  gencode(a3); sv_rn=sv();
			  gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = getelementptr inbounds [%d x i32]* %%_A%d,",rn+1,array_size[ar]+1,ar);
			  print(" i32 0, i32 %%%d\n",sv_rn);
			  print("\tstore i32 %%%d, i32 * %%%d, align 4\n",rn,rn+1);
			  rn+=2; return;											/* store to array */
	case NEG: gencode(l); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = mul nsw i32 %%%d, -1\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op negate */
	case NOT: gencode(l); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = xor i32 %%%d, -1\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op not */
	case '+': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = add nsw i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op add */
	case '-': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = sub nsw i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op sub */
	case '*': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = mul nsw i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op mul */
	case '/': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = sdiv i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op div */
	case MOD: gencode(l); sv_rn=sv(); gencode(r) ; print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = srem i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op mod */
	case AND: gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = and i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op and */
	case OR:  gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = or i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op or */
	case XOR: gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = xor i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* op xor */
	case '=': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = icmp eq i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\t%%%d = sext i1 %%%d to i32\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* compare(=) */
	case '<': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = icmp slt i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\t%%%d = sext i1 %%%d to i32\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* compare(<) */
	case '>': gencode(l); sv_rn=sv(); gencode(r); print("\t%%%d = load i32* %%acc, align 4\n",rn);
			  print("\t%%%d = icmp sgt i32 %%%d, %%%d\n",rn+1,sv_rn,rn); rn++;
			  print("\t%%%d = sext i1 %%%d to i32\n",rn+1,rn); rn++;
			  print("\tstore i32 %%%d, i32* %%acc\n",rn); rn++; return;	/* compare(>) */
	case LINENUMBER: return;	/* line number (dummy) */
	case LABEL: return;			/* label(dummy) */
	case REM: return;			/* remark(dummy) */
	case INLINE: return;		/* inline(dummy) */
	case PRINTX: return;		/* printx(dummy) */
	case GOTO: mk_goto( val(l) ); return;		/* goto */
	case GOLBL: mk_goto_lbl( val(l) ); return;		/* goto label */
	case IF: mk_if_then(l); return;	/* if then */
	case ELSE: mk_else(); return;	/* else */
	case ENDIF: mk_endif(); return;	/* endif */
	case FOR:	/*  FOR */
		f1=l; f2=node[r].op; f3=node[r].left; f4=node[r].right;
		if (f2==TO) {
			f5=node[f4].op; f6=node[f4].left; f7=node[f4].right;
			if (f5==STEP) { /* for f1=f3 to f6 step f7 */
				mk_for(f1,f3,f6,f7);
			} else {
				printf("Error: 'STEP' Error in %d\n",cur_ln); error_flag=1;
			}
		} else {
				printf("Error: 'TO' Error in %d\n",cur_ln); error_flag=1;
		}
		return;
	case NEXT: mk_next(l); return;	/* next */
	case PRINT:	/* print */
		gencode(l);
		print("\t%%%d = load i32* %%acc, align 4\n",rn);
		print("\t%%%d = call i32(i8*,...)* @printf(i8* getelementptr inbounds([4 x i8]* @.1,",rn+1);
		print(" i32 0, i32 0), i32 %%%d) nounwind\n",rn); rn+=2;
		return;
	case INPUT:	/* input */
		print("\t%%%d = call i32(i8*,...)* @printf(i8* getelementptr inbounds([3 x i8]* @.2,",rn);
		print(" i32 0, i32 0)) nounwind\n"); rn++;
		print("\t%%%d = call i8* @gets(i8* getelementptr inbounds ([1024 x i8]* @buf,",rn);
		print(" i32 0, i32 0)) nounwind\n"); rn++;
		print("\t%%%d = call i32 @atoi(i8* getelementptr inbounds ([1024 x i8]* @buf,",rn);
		print(" i32 0, i32 0)) nounwind\n");
		print("\tstore i32 %%%d, i32* %%_V%d ,align 4\n",rn,val(l)); rn++;
		return;
	case END: mk_end(); return;	/* end */
	}
}

/*********************************************************
**		Subroutines
**********************************************************/
void rem() /* REM */
{
	print(";\tREM %s",remark);
}
void inline_() /* INLINE */
{
	print(";\tINLINE\n\t%s",inlines);
}
void printx() /* PRINTX */
{
	int l;
	l=strlen(prt_str);
	if ((prt_str[l-1]=='\r')||(prt_str[l-1]=='\n')) { prt_str[l-1]='\0'; l--; };
	strcpy(printx_str[printx_total++],prt_str);
	print("\t%%%d = call i32(i8*,...)* @printf(i8* getelementptr inbounds([%d x i8]* @str",rn,l+2);
	print("%d, i32 0, i32 0)) nounwind\n",printx_total); rn++;
}

void mk_end() /* END */
{
	print("\tbr label %%_END\n"); print("GOTO_END:\n");
}

void mk_goto(int p) /* GOTO */
{
	int n;
	n=ref_line(p); print("\tbr label %%_L%d\n",n); print("_DUMMY%d:\n",dummy_nm++); 
}
void mk_goto_lbl(int p) /* GOTO label */
{
	int n;
	n=ref_lbl(p); print("\tbr label %%LBL%d\n",n); print("_DUMMY%d:\n",dummy_nm++); 
}

void mk_if_then(int p) /* IF,THEN */
{
	int ilbl;
	ilbl=if_total;
	if_stack[if_stackp++]=if_total;
	if_stack2[if_stackp2++]=if_total;
	if_total++;
	print("\t;IF\n");
	gencode(p);
	print("\t%%%d = load i32* %%acc, align 4\n",rn);
	print("\t%%%d = trunc i32 %%%d to i1\n",rn+1,rn); rn++;
	print("\tbr i1 %%%d, label %%_IL%d_THEN, ",rn,ilbl); rn++;
	print("label %%_IL%d_ELSE\n",ilbl);
	print("_IL%d_THEN:\n",ilbl);
	return;
}
void mk_else() /* ELSE */
{
	int ilbl;
	if (if_stackp==0) {
		ilbl=0; printf("Error: ELSE without IF.  in %d\n",cur_ln); error_flag=1;
	} else {
		ilbl=if_stack[--if_stackp];
	}
	print("\tbr label %%_IL%d_ENDIF\n",ilbl);
	print("_IL%d_ELSE:\n",ilbl);
	return;
}
void mk_endif() /* ENDIF */
{
	int i,j,ilbl,flag;
	if (if_stackp2==0) {
		printf("Error: ENDIF without IF.  in %d\n",cur_ln); error_flag=1;
	}
	for (i=0;i<if_stackp2;i++) {
		ilbl=if_stack2[i];
		if (if_stackp==0) {
			print("\tbr label %%_IL%d_ENDIF\n",ilbl);
			print("_IL%d_ENDIF:\n",ilbl);
		} else {
			flag=0;
			for (j=0;j<if_stackp;j++) {
				if (if_stack[j]==ilbl) flag=1;
			}
			if (flag==0) {
				print("\tbr label %%_IL%d_ENDIF\n",ilbl);
				print("_IL%d_ENDIF:\n",ilbl);
			} else {
				print("\tbr label %%_IL%d_ELSE\n",ilbl);
				print("_IL%d_ELSE:\n",ilbl);
				print("\tbr label %%_IL%d_ENDIF\n",ilbl);
				print("_IL%d_ENDIF:\n",ilbl);
			}
		}
	}
	return;
}

void mk_for(int f1,int f2,int f3,int f4) /* FOR */
{
	int step,flbl,sv_r_nm;
	if (f4==-1) {
		step=1; /* no STEP */
	} else {
		if (node[f4].op=='C') {
			step=node[f4].left;
		} else {
			step=1; printf("FOR's STEP must be constant. in %d\n",cur_ln);
		}
	}
	if (step==0) {
		step=1; printf("STEP should not be zero.\n");
	}
	/*   var = f1     */
	print("\t;FOR\n");
	if (node[f1].op == 'V') {
		gencode(f2);
	}
	print("\t%%%d = load i32* %%acc, align 4\n",rn);
	print("\t%%%d = sub nsw i32 %%%d, %d\n",rn+1,rn,step);
	print("\tstore i32 %%%d, i32* %%_V%d\n",rn+1,val(f1));  rn+=2;
	flbl=for_total;
	for_stack[for_stackp++]=for_total;
	for_var[for_total]=val(f1);
	for_line[for_total]=cur_ln;
	for_total++;
	print("\tbr label %%_FL%d\n",flbl);
	print("_FL%d:\n",flbl);
	print("\t%%%d = load i32* %%_V%d, align 4\n",rn,val(f1));
	print("\t%%%d = add nsw i32 %%%d, %d\n",rn+1,rn,step);
	print("\tstore i32 %%%d, i32* %%_V%d\n",rn+1,val(f1)); sv_r_nm=rn+1; rn+=2;
	gencode(f3);
	print("\t%%%d = load i32* %%acc, align 4\n",rn);
	if (step>0) {
		print("\t%%%d = icmp sgt i32 %%%d, %%%d\n",rn+1,sv_r_nm,rn); rn++;
		print("\tbr i1 %%%d, label %%_FL%d_END, ",rn,flbl); rn++;
		print("label %%_FL%d_F\n",flbl);
	} else if (step<0) {
		print("\t%%%d = icmp slt i32 %%%d, %%%d\n",rn+1,sv_r_nm,rn); rn++;
		print("\tbr i1 %%%d, label %%_FL%d_END, ",rn,flbl); rn++;
		print("label %%_FL%d_F\n",flbl);
	}
	print("_FL%d_F:\n",flbl);
	return;
}
void mk_next(int p) /* NEXT */
{
	int flbl,fvar,fl;
	if (for_stackp==0) {
		flbl=99999; printf("Error: NEXT without FOR.  in %d\n",cur_ln); error_flag=1;
	} else {
		flbl=for_stack[--for_stackp];
	}
	fvar=for_var[flbl]; fl=for_line[flbl];
	if (p==-1) { /* NEXT without var */
		print("\tbr label %%_FL%d\n",flbl);
		print("\t;NEXT\n");
		print("_FL%d_END:\n",flbl);
	} else { /* NEXT with var */
		if (val(p)!=fvar) {
			printf("Error: FOR and NEXT variable doesn't match in %d,%d\n",fl,cur_ln); error_flag=1;
		}
		print("\tbr label %%_FL%d\n",flbl);
		print("\t;NEXT\n");
		print("_FL%d_END:\n",flbl);
	}
	return;
}

void initnode() /* init tree */
{
	nodeptr = 0; if_stackp = 0; if_stackp2 = 0;
}

int mknd(int op, int l, int r) /* make node of tree */
{
	if ((op==NEG)&&(node[l].op=='C')) {	  /* negate op + const */
		node[l].left = -val(l); return l;
	}
	node[nodeptr].op = op; node[nodeptr].left = l; node[nodeptr].right = r;
	return  nodeptr++;
}

int create_id(char *id_name) /* identifier */
{
	strcpy( identifier[id_total], id_name ); id_total++;
	return id_total-1;
}
int id_exist(char *id_name)
{
	int	i;
	if (id_total==0) return -1;
	for (i=0;i<id_total;i++) {
		if ( my_stricmp(identifier[i],id_name )==0 ) { return i; }
	}
	return -1;
}

int mk_var(int p) /* integer variable */
{
	int i,id_nm=p;
	if ((i=var_exist(id_nm))==-1) {
		i=create_var(id_nm); print("\t%%_V%d = alloca i32 , align 4\n",i);
	}
	return i;
}
int create_var(int id_nm)
{
	strcpy( var_id[var_total], identifier[id_nm] ); var_total++;
	return var_total-1;
}
int var_exist(int id_nm)
{
	int	i;
	if (var_total==0) { return -1; }
	for (i=0;i<var_total;i++) {
		if ( my_stricmp(var_id[i], identifier[id_nm] )==0 ) { return i; }
	}
	return -1;
}

int mk_array(int p , int size) /* integer array */
{
	int i,id_nm=(int)p;
	if ((i=array_exist(id_nm))==-1) {
		i=create_array(id_nm,size);
		print("\t%%_A%d = alloca [%d x i32], align 4\n",i,size+1);
	}
	return i;
}
int create_array(int id_nm,int size)
{
	strcpy( array_id[array_total], identifier[id_nm] ); array_size[array_total]=size; array_total++;
	return array_total-1;
}
int array_exist(int id_nm)
{
	int	i;
	if (array_total==0) { return -1; }
	for (i=0;i<array_total;i++) {
		if ( my_stricmp(array_id[i], identifier[id_nm] )==0 ) { return i; }
	}
	return -1;
}
int get_array(int id_nm)
{
	int i;
	i= array_exist(id_nm);
	if (i == -1) { printf("Error: illegal array id=%d %s\n",id_nm,identifier[id_nm]); i=0; }
	return i;
}

int mk_lbl(int p) /* label */
{
	int	i,id_nm=p;
	if ((i=lbl_exist(id_nm))==-1) {
		i=create_lbl(id_nm); lbl_flag[i]=0x01; print("\tbr label %%LBL%d\n",i); print("LBL%d:\n",i);
		return i;
	} else {
		if ( (lbl_flag[i] == 0x01) || (lbl_flag[i] == 0x03) ) {
			print("LBL%d:\n",i);
			printf("error: Duplicate Label %s\n",lbl_id[i]);
		} else {
			lbl_flag[i]+=0x01;  print("\tbr label %%LBL%d\n",i); print("LBL%d:\n",i);
		}
		return i;
	}
}
int ref_lbl(int p)
{
	int	i,id_nm=p;
	if ((i=lbl_exist(id_nm))==-1) {
		i=create_lbl(id_nm);
		lbl_flag[i]=0x02;	/*   referenced flag   */
	} else {
		lbl_flag[i]|=0x02;	/*   referenced flag   */
	}
	lbl_access[lbl_acs][0]=i; lbl_access[lbl_acs][1]=cur_ln; lbl_acs++;
	return i;
}
int create_lbl(int id_nm)
{
	strcpy( lbl_id[lbl_total], identifier[id_nm] ); lbl_total++;
	return lbl_total-1;
}
int lbl_exist(int id_nm)
{
	int	i;
	if (lbl_total==0) { return -1; }
	for (i=0;i<lbl_total;i++) {
		if ( my_stricmp(lbl_id[i], identifier[id_nm] )==0 ) { return i; }
	}
	return -1;
}

void mk_line(int p) /* line number */
{
	int ll;
	int line=p;
	if ( cur_ln < prv_ln ) {
		printf("warning: Line %d < %d \n",cur_ln,prv_ln);
	} else {
		prv_ln=cur_ln;
	}
	cur_ln=line; rdln++;
	if ( (ll=line_exist(line))<0 ) {
		ll=create_line(line);line_flag[ll]=0x01; print("\tbr label %%_L%d\n\n_L%d:\n",cur_ln,cur_ln);
	} else {
		if ( (line_flag[ll] == 0x01) || (line_flag[ll] == 0x03) ) {
			print("\n_L%d:\n",cur_ln);
			printf("error: Dupulicate Line %d\n",line);
		} else {
			line_flag[ll]+=0x01; print("\tbr label %%_L%d\n\n_L%d:\n",cur_ln,cur_ln);
		}
	}
}
int ref_line(int line)
{
	int l;
	if ( (l=line_exist(line))<0 ) {
		l=create_line(line); line_flag[l]=0x02;
	} else {
		line_flag[l]|=0x02;
	}
	line_access[line_acs][0]=l; line_access[line_acs][1]=cur_ln; line_acs++;
	return line;
}
int create_line(int line)
{
	line_num[line_total]=line; line_total++;
	return line_total-1;
}
int line_exist(int line)
{
	int i;
	if (line_total==0) { return -1; }
	for (i=0;i<line_total;i++) {
		if ( line_num[i]==line ) { return i; }
	}
	return -1;
}

int my_stricmp(char *s1,char *s2)
{
	char c1,c2;
	while (1) {
		c1=*s1++; c2=*s2++; c1=tolower(c1); c2=tolower(c2);
		if ((c1=='\0')||(c2=='\0')||(c1!=c2)) { break; }
	}
	return (int) c1-c2;
}
