#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "curl.h"
#include "jsmn.h"

#define IP_ADDRESS	"192.168.1.196"

#define N	8		// max of bulb

#define LINELEN  1024
char url_str[LINELEN],mac_str[LINELEN],list_str[LINELEN*60],post_str[LINELEN*60];
struct MemoryStruct { char *memory; size_t size; };
struct MemoryStruct chunk;

int WriteMemoryCallback(void *contents, size_t size, size_t nmemb, void *userp);
int GetMACList(char *buf);
int FindMAC(char *buf,int pos);
int MakePOST(char *buf,int num,char *string);

void send_hue_commnad(int n,char *s)
{
	CURL *curl;
	CURLcode res;
	jsmn_parser p;
	jsmntok_t tokens[40];
	int pos = 0 , mac_cnt = 0 , ok_flag = 0;
	char buf[256];
	
	// parameters
	strcpy(url_str,IP_ADDRESS);
	strcat(url_str,"/api/newdeveloper/lights/");
	sprintf(buf,"%d",n); strcat(url_str,buf);
	strcat(url_str,"/state");
	strcpy(post_str,s);
	
	// POST it
	chunk.memory = malloc(1); chunk.size = 0;
	curl = curl_easy_init();
	curl_easy_setopt(curl, CURLOPT_URL, url_str);
	curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, "PUT");
	curl_easy_setopt(curl, CURLOPT_POSTFIELDS, post_str );
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
	curl_easy_setopt(curl, CURLOPT_WRITEDATA, (void *)&chunk);
	curl_easy_perform(curl);
	curl_easy_cleanup(curl);
	
	// result
	
	//printf("%s\n", chunk.memory);
	
	jsmn_init(&p);
	jsmn_parse(&p, chunk.memory , tokens, 40);
	
	if (chunk.memory) { free(chunk.memory); }
}

int WriteMemoryCallback(void *contents, size_t size, size_t nmemb, void *userp)
{
	size_t realsize = size * nmemb;
	struct MemoryStruct *mem = (struct MemoryStruct *)userp;
	mem->memory = realloc(mem->memory, mem->size + realsize + 1);
	if (mem->memory == NULL) { printf("Errpr: Not enough memory\n"); exit(1); }
	memcpy(&(mem->memory[mem->size]), contents, realsize);
	mem->size += realsize;
	mem->memory[mem->size] = 0;
	return realsize;
}

void hue(int n,int h) // hue= 0..65535
{
	char pbuf[256],buf[256];
	strcpy(pbuf,"{\"hue\":"); sprintf(buf,"%d",h); strcat(pbuf,buf); strcat(pbuf,"}");
	send_hue_commnad(n,pbuf);
}
void hue_all(int h)
{
	int i;
	for (i=1;i<=N;i++) { hue(i,h); }
}
void hue_all_rnd()
{
	int i,h;
	for (i=1;i<=N;i++) { h=rand()%65536;  hue(i,h); }
}


void bright(int n,int br) // br= 0..255
{
	char pbuf[256],buf[256];
	strcpy(pbuf,"{\"bri\":"); sprintf(buf,"%d",br); strcat(pbuf,buf); strcat(pbuf,"}");
	send_hue_commnad(n,pbuf);
}
void bright_all(int br)
{
	int i;
	for (i=1;i<=N;i++) { bright(i,br); }
}
void bright_all_rnd()
{
	int i,br;
	for (i=1;i<=N;i++) { br=rand()%255 + 1;  bright(i,br); }
}


void light_on(int n)
{
	char pbuf[256];
	strcpy(pbuf,"{\"on\":true}");
	send_hue_commnad(n,pbuf);
}
void light_on_all()
{
	int i;
	for (i=1;i<=N;i++) { light_on(i); }
}

void light_off(int n)
{
	char pbuf[256];
	strcpy(pbuf,"{\"on\":false}");
	send_hue_commnad(n,pbuf);
}
void light_off_all()
{
	int i;
	for (i=1;i<=N;i++) { light_off(i); }
}


int main()
{
	int n,h;
	printf("Hue cube test - Start\n");
	light_on_all();
	bright_all(128);
	hue_all(32000);
	getchar();

	for (n=0;n<10;n++) { bright_all_rnd(); Sleep(800); }
	
	for (h=0;h<60000;h+=(60000/7)) {
		hue_all(h);
		for (n=0;n<2;n++) { bright_all_rnd(); Sleep(800); }
	}
	
	for (n=0;n<5;n++) { hue_all_rnd(); Sleep(800); }

	bright_all(127);
	hue_all(32000);
	light_off_all();

	printf("End\n");
	getchar();
	
	return 0;
}

