#include <windows.h> 
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h> 

#define FUNC __declspec(dllimport) __stdcall
extern "C" HANDLE FUNC OpenHidHandle(unsigned short vendor_id, unsigned short product_id);
extern "C" void FUNC ReadReport(HANDLE handle,unsigned char *InputReport,int *len);
extern "C" void FUNC WriteReport(HANDLE handle,unsigned char *OutputReport, int *len);
extern "C" void FUNC CloseHidHandle(HANDLE handle);

HANDLE hRsDevHandle;

const USHORT VID = 0x057e; // Nintendo (?)
const USHORT PID = 0x0306; // Wii-Remote (?)

#define MAXREPORTSIZE 256
int		InputLength,OutputLength;
unsigned char	InputReport[MAXREPORTSIZE];
unsigned char	OutputReport[MAXREPORTSIZE];

unsigned char	button1,button2;
unsigned char	Ax,Ay,Az;
unsigned char	wii_remote_loop_flag;
unsigned char	wii_remote_in_use;

void Wii_Remote_Input(void);
void Wii_Remote_mode_0x31(void);
int Wii_Remote_check(void);

void Sleep2(int msec)
{
	LARGE_INTEGER f;
	LARGE_INTEGER t1,t2;
	double t;
	QueryPerformanceFrequency(&f);
	QueryPerformanceCounter(&t1);
	while (1) {
		QueryPerformanceCounter(&t2);
		t = (double)t2.QuadPart - (double)t1.QuadPart;
		t /= (double)f.QuadPart;
		t *= 1000;
		if (t>(double)msec) { return; }
	}
}

void Report_0x11(unsigned char data)
{
	OutputReport[0]=0x11; // Report ID
	OutputReport[1]=data;
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Report_0x12(unsigned char data1,unsigned char data2)
{
	OutputReport[0]=0x12; // Report ID
	OutputReport[1]=data1;
	OutputReport[2]=data2;
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Report_0x13(unsigned char data)
{
	OutputReport[0]=0x13; // Report ID
	OutputReport[1]=data;
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Wii_Remote_mode_0x30(void)
{
	// Set Report Type
	Report_0x12(0x00,0x30);  // button ONLY Report Mode
}

void Wii_Remote_mode_0x31(void)
{
	// Set Report Type
	Report_0x12(0x00,0x31);  // Acc Sensor + button  Report Mode
}

void Wii_Remote_Input(void)
{
	ReadReport( hRsDevHandle , InputReport, &InputLength);
	if ( InputReport[0]==0x30 ) {
		button1=InputReport[1]; button2=InputReport[2];
	}
	if ( InputReport[0]==0x31 ) {
		button1=InputReport[1]; button2=InputReport[2];
		Ax = InputReport[3];
		Ay = InputReport[4];
		Az = InputReport[5];
	}
}

void Wii_Remote_Input_Main(void *)
{
	// wii remote input thread
	while (wii_remote_loop_flag) {
		wii_remote_in_use=1;
		Wii_Remote_Input();
		Sleep(100);
	}
	wii_remote_in_use=0;
	return;
}

uintptr_t wii_th;

int Wii_Remote_check(void)
{
	Ax=0;
	wii_remote_loop_flag=1;
	wii_th = _beginthread( Wii_Remote_Input_Main , 0 , NULL );
	Sleep2(100);
	wii_remote_loop_flag=0;
	return (Ax!=0);
}

void Stop_Wii_remote_th(void)
{
	if (wii_remote_in_use==1) {
		TerminateThread( (HANDLE)wii_th , -1); // kill thread  if it stopped
	}
}

void MainLoop(void)
{
	POINT pt;
	int ax,ay;
	int vx,vy;
	int lx,ly;
	int bt1,bt2,bt3,bt4,bt5,bt6;
	vx=0;vy=0;
	bt1=0;bt2=0;bt3=0;bt4=0;bt5=0;bt6=0;

	while (1) {
		if (kbhit()) { if (getch()==0x1B) { break; } } // ESC key  to Quit
		
		Wii_Remote_Input(); // Wii Remote
		if (button2==0x80) { break; }  // Home button  to Quit
		
		if (button2&0x08) { // A button
			if (bt1==0) { mouse_event(MOUSEEVENTF_RIGHTDOWN,0, 0, 0, NULL); bt1=1; }
		} else {
			if (bt1==1) { mouse_event(MOUSEEVENTF_RIGHTUP,0, 0, 0, NULL); bt1=0; }
		}
		if (button2&0x04) { // B button
			if (bt2==0) { mouse_event(MOUSEEVENTF_LEFTDOWN,0, 0, 0, NULL); bt2=1; }
		} else {
			if (bt2==1) { mouse_event(MOUSEEVENTF_LEFTUP,0, 0, 0, NULL); bt2=0; }
		}
		if (button2&0x02) { // (1) button
			if (bt3==0) { bt3=1; }
			mouse_event(MOUSEEVENTF_WHEEL,0, 0, 64, 0);
		} else {
			bt3=0;
		}
		if (button2&0x01) { // (2) button
			if (bt4==0) { bt4=1; }
			mouse_event(MOUSEEVENTF_WHEEL,0, 0, -64, 0);
		} else {
			bt4=0;
		}
		
		if (button1&0x10) {  // (+) button
			if (bt5==0) {
				Report_0x13(0x01); Sleep2(55); Report_0x13(0x00);  //Rumble
				mouse_event(MOUSEEVENTF_WHEEL,0, 0, -64, 0);
				bt5=1;
			}
		} else {
			bt5=0;
		}
		if (button2&0x10) {  // (-) button
			if (bt6==0) {
				Report_0x13(0x01); Sleep2(55); Report_0x13(0x00);  //Rumble
				mouse_event(MOUSEEVENTF_WHEEL,0, 0, 64, 0);
				bt6=1;
			}
		} else {
			bt6=0;
		}
		
		ax=0; ay=0;
		if (button1&0x08) { ay = 1;  } // up
		if (button1&0x04) { ay = -1; } // down
		if (button1&0x02) { ax = 1;  } // right
		if (button1&0x01) { ax = -1; } // left
		
		
		// move Mouse Cursor 
		GetCursorPos(&pt);
		lx = pt.x; ly = pt.y;
		if ( (ax>0)&&(vx>=0) ) { vx++; if (vx>  16) { vx=  16;}  }
		if ( (ax<0)&&(vx<=0) ) { vx--; if (vx< -16) { vx= -16;}  }
		if ( (ax<0)&&(vx>=0) ) { vx/=4; }
		if ( (ax>0)&&(vx<=0) ) { vx/=4; }
		if ( (ay>0)&&(vy>=0) ) { vy++; if (vx>  16) { vx=  16;}  }
		if ( (ay<0)&&(vy<=0) ) { vy--; if (vx< -16) { vx= -16;}  }
		if ( (ay<0)&&(vy>=0) ) { vy/=4; }
		if ( (ay>0)&&(vy<=0) ) { vy/=4; }
		if ( ax == 0 ) { vx /=2; }
		if ( ay == 0 ) { vy /=2; }
		if (vx >  2) { lx += (vx-2); }
		if (vx < -2) { lx += (vx+2); }
		if (vy >  2) { ly -= (vy-2); }
		if (vy < -2) { ly -= (vy+2); }
		SetCursorPos(lx,ly);
	}
}

int main( int argc, char *argv[])
{ 
	int i;
	
	hRsDevHandle = OpenHidHandle(VID,PID);
	if ( hRsDevHandle == INVALID_HANDLE_VALUE) {
		MessageBox(0,"Wii-Remote not found.",0,0);
		return 1;
	}
	
	Wii_Remote_mode_0x31();
	if ( Wii_Remote_check() ) {
		printf("###########################################\n");
		printf("#                                         #\n");
		printf("#   Wii-Mice Test version 0.1             #\n");
		printf("#                  build 2006.12.10       #\n");
		printf("#                                         #\n");
		printf("###########################################\n");
		printf("\n");
		printf("Usage:\n");
		printf("   up/down/left/right button  ... Move cursor\n");
		printf("   B button  ... Left click\n");
		printf("   A button  ... Right click\n");
		printf("   (1) button  ... Wheel up\n");
		printf("   (2) button  ... Wheel down\n");
		printf("   (+) button  ... Wheel down\n");
		printf("   (-) button  ... Wheel up\n");
		printf("   Home button  ... Quit\n");
		printf("\n");

		Report_0x11(0x10); // LED1 on
		
		MainLoop();
		
	} else {
		
		MessageBox(0,"Wii-Remote cannot open.",0,0);
		Stop_Wii_remote_th();
	}
	CloseHidHandle( hRsDevHandle );
	return 0;
} 
