#include <afxwin.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h> 

#define FUNC __declspec(dllimport) __stdcall
extern "C" HANDLE FUNC OpenHidHandle(unsigned short vendor_id, unsigned short product_id);
extern "C" void FUNC ReadReport(HANDLE handle,unsigned char *InputReport,int *len);
extern "C" void FUNC WriteReport(HANDLE handle,unsigned char *OutputReport, int *len);
extern "C" void FUNC CloseHidHandle(HANDLE handle);

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);

HWND hWnd;
HPEN pen;
HBRUSH brush;
HFONT font;

#define I_BLACK RGB(0,0,0)
#define I_WHITE RGB(255,255,255)

HANDLE hRsDevHandle;

const USHORT VID = 0x057e; // Nintendo (?)
const USHORT PID = 0x0306; // Wii-Remote (?)

#define MAXREPORTSIZE 256
int		InputLength,OutputLength;
unsigned char	InputReport[MAXREPORTSIZE];
unsigned char	OutputReport[MAXREPORTSIZE];

unsigned char	button1,button2;
unsigned char	Ax,Ay,Az;
unsigned char	wii_remote_loop_flag;
unsigned char	wii_remote_in_use;

int				Ix1,Iy1,Ix2,Iy2;
int				Ix3,Iy3,Ix4,Iy4;

void Wii_Remote_Input(void);
void Wii_Remote_mode_0x31(void);
int Wii_Remote_check(void);
void Display_Event(void);

void Sleep2(int msec)
{
	LARGE_INTEGER f;
	LARGE_INTEGER t1,t2;
	double t;
	QueryPerformanceFrequency(&f);
	QueryPerformanceCounter(&t1);
	while (1) {
		QueryPerformanceCounter(&t2);
		t = (double)t2.QuadPart - (double)t1.QuadPart;
		t /= (double)f.QuadPart;
		t *= 1000;
		if (t>(double)msec) { return; }
	}
}

void Report_0x11(unsigned char data)
{
	OutputReport[0]=0x11; // Report ID
	OutputReport[1]=data;
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Report_0x12(unsigned char data1,unsigned char data2)
{
	OutputReport[0]=0x12; // Report ID
	OutputReport[1]=data1;
	OutputReport[2]=data2;
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Report_0x13(unsigned char data)
{
	OutputReport[0]=0x13; // Report ID
	OutputReport[1]=data;
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Report_0x16_type1(unsigned char adr,unsigned char len,unsigned char *buf)
{

	OutputReport[0]=0x16; // Report ID
	OutputReport[1]=0x04; // 00(EEPROM) or 0x04(other I2C 1byte type) or 0x08(I2C 2byte type)
	OutputReport[2]=adr; // I2C ADRS
	OutputReport[3]=0xFF; // ignore
	OutputReport[4]=buf[0];  // Mem_Adr or Cmd
	OutputReport[5]=len-1;  // len >= 2
	OutputReport[6]=buf[1]; OutputReport[7]=buf[2]; OutputReport[8]=buf[3]; OutputReport[9]=buf[4];
	OutputReport[10]=buf[5];OutputReport[11]=buf[6];OutputReport[12]=buf[7];OutputReport[13]=buf[8];
	OutputReport[14]=buf[9];OutputReport[15]=buf[10];OutputReport[16]=buf[11];OutputReport[17]=buf[12];
	OutputReport[18]=buf[13];OutputReport[19]=buf[14];OutputReport[20]=buf[15];OutputReport[21]=buf[16];
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Report_0x1a(unsigned char data)
{
	OutputReport[0]=0x1a; // Report ID
	OutputReport[1]=data;
	WriteReport( hRsDevHandle , OutputReport , &OutputLength);
}

void Wii_Remote_mode_0x30(void)
{
	// Set Report Type
	Report_0x12(0x00,0x30);  // button ONLY Report Mode
}

void Wii_Remote_mode_0x31(void)
{
	// Set Report Type
	Report_0x12(0x00,0x31);  // Acc Sensor + button  Report Mode
}

void Wii_IR_init(void)
{
	unsigned char buf[16];
	unsigned char p0,p1,p2,p3;

	Report_0x13(0x04); // IR on 1  ... OSC 25MHz --> start
	Sleep2(10);
	Report_0x1a(0x04); // IR on 2  ... Chip enable #CE --> Low (Enable)
	
	// Setup IR Sensivity
	// p0=0x72; p1=0x20; p2=0x1F; p3=0x03; // Sensitivity 1
	   p0=0xC8; p1=0x36; p2=0x35; p3=0x03; // 2
	// p0=0xAA; p1=0x64; p2=0x63; p3=0x03; // 3
	// p0=0x96; p1=0xB4; p2=0xB3; p3=0x04; // 4
	// p0=0x96; p1=0xFE; p3=0xFE; p3=0x05; // 5
		
	buf[0]=0x30; buf[1]=0x01; // ??
	Report_0x16_type1(0xB0, 2 , buf); Sleep2(10);
	buf[0]=0x00; buf[1]=0x02; buf[2]=0x00; buf[3]=0x00; buf[4]=0x71; buf[5]=0x01; buf[6]=0x00; buf[7]=p0;
	Report_0x16_type1(0xB0, 8 , buf); Sleep2(10);
	buf[0]=0x07; buf[1]=0x00; buf[2]=p1;
	Report_0x16_type1(0xB0, 3 , buf); Sleep2(10);
	buf[0]=0x1A; buf[1]=p2; buf[2]=p3;
	Report_0x16_type1(0xB0, 3 , buf); Sleep2(10);
	buf[0]=0x33; buf[1]=0x03;
	Report_0x16_type1(0xB0, 2 , buf); Sleep2(10);
	buf[0]=0x30; buf[1]=0x08; // ??
	Report_0x16_type1(0xB0, 2 , buf); Sleep2(10);
	
	Report_0x12(0x00,0x33); // mode 0x33 ... IR Interrupt start
}

void Wii_Remote_Input(void)
{
	unsigned char r;
	int s;
	ReadReport( hRsDevHandle , InputReport, &InputLength);
	
	r = InputReport[0];
	if ( (r & 0xF0) == 0x30 )  {
		button1=InputReport[1]; button2=InputReport[2];
		
		if ( r & 0x01 ) {
			Ax = InputReport[3];
			Ay = InputReport[4];
			Az = InputReport[5];
		}
		if ( r & 0x02 ) {
			// ir
			Ix1 = InputReport[6];
			Iy1 = InputReport[7];
			s   = InputReport[8];
			Ix1 += (s & 0x30) <<4;
			Iy1 += (s & 0xC0) <<2;
			
			Ix2 = InputReport[9];
			Iy2 = InputReport[10];
			s   = InputReport[11];
			Ix2 += (s & 0x30) <<4;
			Iy2 += (s & 0xC0) <<2;
			
			Ix3 = InputReport[12];
			Iy3 = InputReport[13];
			s   = InputReport[14];
			Ix3 += (s & 0x30) <<4;
			Iy3 += (s & 0xC0) <<2;
			
			Ix4 = InputReport[15];
			Iy4 = InputReport[16];
			s   = InputReport[17];
			Ix4 += (s & 0x30) <<4;
			Iy4 += (s & 0xC0) <<2;
		}
	}
}

void Wii_Remote_Input_Main(void *)
{
	// wii remote input thread
	while (wii_remote_loop_flag) {
		wii_remote_in_use=1;
		Wii_Remote_Input();
		Sleep(100);
	}
	wii_remote_in_use=0;
	return;
}

uintptr_t wii_th;

int Wii_Remote_check(void)
{
	Ax=0;
	wii_remote_loop_flag=1;
	wii_th = _beginthread( Wii_Remote_Input_Main , 0 , NULL );
	Sleep2(100);
	wii_remote_loop_flag=0;
	return (Ax!=0);
}

void Stop_Wii_remote_th(void)
{
	if (wii_remote_in_use==1) {
		TerminateThread( (HANDLE)wii_th , -1); // kill thread  if it stopped
	}
}

void Wii_IR_main(void *)
{
	Sleep2(500);

	wii_remote_loop_flag=1;
	
	while (wii_remote_loop_flag) {
		Wii_Remote_Input(); // Wii Remote
		
		if (button2==0x80) { // Home button
			SendMessage(hWnd,WM_DESTROY,0,0); // quit
		}
		
		if ((Ix1!=1023)||(Ix2!=1023)) {
			Display_Event();
		}
	}
}


int APIENTRY WinMain(HINSTANCE hInst,HINSTANCE,LPSTR cmd,int show)
{
	MSG msg;
	HACCEL hAccel;
	WNDCLASSEX wndclass;
	HANDLE hMutex;
	
	hMutex = CreateMutex(NULL, TRUE, "wii-test-001");
	if (!hMutex) { return FALSE; }
	if (GetLastError() == ERROR_ALREADY_EXISTS) {
		return FALSE;
	}
	
	hRsDevHandle = OpenHidHandle(VID,PID);
	if ( hRsDevHandle == INVALID_HANDLE_VALUE) {
		MessageBox(0,"Wii-Remote not found.",0,0);
		return 1;
	}
	
	Wii_Remote_mode_0x31();
	if ( !Wii_Remote_check() ) {
		MessageBox(0,"Wii-Remote cannot open.",0,0);
		Stop_Wii_remote_th();
		CloseHidHandle( hRsDevHandle );
		return 1;
	}
	
	Report_0x11(0x10); // LED1 on
	Wii_IR_init();
	_beginthread( Wii_IR_main , 0 , NULL );
	
	wndclass.cbSize        = sizeof(wndclass);
	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = WndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInst;
	wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
	wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = "wnd-001";
	wndclass.hIconSm       = 0;
	RegisterClassEx (&wndclass);
	hWnd=CreateWindow("wnd-001", "Wii Remote IR Sensor Test",
			WS_OVERLAPPEDWINDOW,10,10,520,420,NULL,NULL,hInst,NULL);
	if (hWnd==NULL) { return FALSE; }
	ShowWindow(hWnd,show); UpdateWindow(hWnd);
	while (GetMessage(&msg,NULL,0,0)) {
		TranslateMessage(&msg); DispatchMessage(&msg);
	}
	return msg.wParam;
}

void Display_Event(void)
{
	//InvalidateRect(hWnd,NULL,FALSE); //display update 1
	InvalidateRect(hWnd,NULL,TRUE); //display update 2
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam)
{
	char buf[255];
	switch (msg) {
	 case WM_CREATE:
		{
			pen=CreatePen(PS_SOLID,1,I_BLACK);
			brush=CreateSolidBrush(I_WHITE);
			font = CreateFont(  16, 0, 0, 0,FW_DONTCARE,false,false,false,
					DEFAULT_CHARSET,false,false,false,false,"System");
		}
		break;
	 case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hdc;
			hdc=BeginPaint(hWnd,&ps);
			SelectObject(hdc,pen);
			SelectObject(hdc,brush);
			SelectObject(hdc,font);
			MoveToEx(hdc,Ix1/2-4,Iy1/2,NULL); LineTo(hdc,Ix1/2+5,Iy1/2);
			MoveToEx(hdc,Ix1/2,Iy1/2-4,NULL); LineTo(hdc,Ix1/2,Iy1/2+5);
			MoveToEx(hdc,Ix2/2-4,Iy2/2,NULL); LineTo(hdc,Ix2/2+5,Iy2/2);
			MoveToEx(hdc,Ix2/2,Iy2/2-4,NULL); LineTo(hdc,Ix2/2,Iy2/2+5);
			MoveToEx(hdc,Ix3/2-4,Iy3/2,NULL); LineTo(hdc,Ix3/2+5,Iy3/2);
			MoveToEx(hdc,Ix3/2,Iy3/2-4,NULL); LineTo(hdc,Ix3/2,Iy3/2+5);
			MoveToEx(hdc,Ix4/2-4,Iy4/2,NULL); LineTo(hdc,Ix4/2+5,Iy4/2);
			MoveToEx(hdc,Ix4/2,Iy4/2-4,NULL); LineTo(hdc,Ix4/2,Iy4/2+5);
			EndPaint(hWnd,&ps);
		}
		break;
	 case WM_KEYDOWN:
		if (wParam==0x1B) { SendMessage(hWnd,WM_DESTROY,0,0); } // ESCL[
		break;
	 case WM_DESTROY:
		DeleteObject(pen); DeleteObject(brush); DeleteObject(font);
		PostQuitMessage(0);
		wii_remote_loop_flag=0;
		Wii_Remote_mode_0x30();
		CloseHidHandle( hRsDevHandle );
		break;
	 default:
		return DefWindowProc(hWnd,msg,wParam,lParam);
	}
	return 0;
}
